/*=========================================================

	padctrl.h

	pbhf[^̎擾ɁAL[s[gB

=========================================================*/
#ifndef PADCTRL_H
#define PADCTRL_H

#include <pspkernel.h>
#include <pspctrl.h>
#include <psprtc.h>
#include <stdbool.h>
#include <stdint.h>
#include "psp/memory.h"
#include "psp/padutil.h"
#include "cgerrs.h"

/*=========================================================
	}N
=========================================================*/
#define PADCTRL_REPEAT_START_DELAY 250000
#define PADCTRL_REPEAT_NEXT_DELAY  100000

#ifdef __cplusplus
extern "C" {
#endif

/*=========================================================
	^`
=========================================================*/
typedef intptr_t PadctrlUID;

/*=========================================================
	֐
=========================================================*/
/*-----------------------------------------------
	padctrlNew
	
	PadctrlAVPadctrlnh𓾂B
-----------------------------------------------*/
PadctrlUID padctrlNew( void );

/*-----------------------------------------------
	padctrlDestroy
	
	PadctrlnhjB
-----------------------------------------------*/
void padctrlDestroy( PadctrlUID uid );

/*-----------------------------------------------
	padctrlSetRepeatButtons
	
	L[s[gLɂ{^ݒ肷B
-----------------------------------------------*/
void padctrlSetRepeatButtons( PadctrlUID uid, PadutilButtons buttons );

/*-----------------------------------------------
	padctrlReadBuffer
	
	L[obt@sceCtrlReadBufferPositive()APIgēǂݏoB
	L[s[gԊuO̎̓gO{^ȊÕ{^ׂĉĂȂƂĕԂB
	
	L[s[gLɂȂĂȂ{^́AςȂɂĂԂ͏ɉĂȂƂĕԂB
	
	ԂlɃL[s[gĂȂ̃{^R[hAG[R[hԂB
	ςȂ𔻒肷Kvꍇ́Ã{^R[h画f邱ƁB
-----------------------------------------------*/
unsigned int padctrlReadBuffer( PadctrlUID uid, SceCtrlData *pad, int count );

/*-----------------------------------------------
	padctrlPeekBuffer
	
	padctrlReadBuffer()Ɠ邪AL[obt@ǂݎɎgAPIɁA
	sceCtrlPeekBufferPositive()g_قȂB
-----------------------------------------------*/
unsigned int padctrlPeekBuffer( PadctrlUID uid, SceCtrlData *pad, int count );

/*-----------------------------------------------
	padctrlResetRepeat
	
	L[s[gԂZbgB
-----------------------------------------------*/
void padctrlResetRepeat( PadctrlUID uid );

#ifdef __cplusplus
}
#endif

#endif
